package ru.yandex.direct.core.entity.banner.type.system;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.core.entity.banner.type.system.BannerStatusShowHelper.getStatusShowNew;

@Component
@ParametersAreNonnullByDefault
public class BannerWithSystemFieldsAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithSystemFields> {

    @Override
    public Class<BannerWithSystemFields> getTypeClass() {
        return BannerWithSystemFields.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithSystemFields> models) {
        LocalDateTime now = LocalDateTime.now();

        models.forEach(banner -> {
            var adGroupInfo = addContainer.getAdGroup(banner);
            checkState(adGroupInfo != null,
                    "could not get adGroup for banner with adgroupId %s and class %s",
                    banner.getAdGroupId(), banner.getClass());
            Long campaignId = adGroupInfo.getCampaignId();

            banner.withId(null)
                    .withCampaignId(campaignId)

                    .withBsBannerId(0L)
                    .withStatusBsSynced(StatusBsSynced.NO)

                    .withStatusShow(getStatusShowNew(banner))
                    .withStatusActive(false)
                    .withStatusArchived(false)

                    .withLastChange(now);
        });
    }
}
