package ru.yandex.direct.core.entity.banner.type.system;

import javax.annotation.ParametersAreNullableByDefault;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.banner.model.Language;
import ru.yandex.direct.dbschema.ppc.enums.BannersLanguage;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusactive;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusarch;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusshow;

@ParametersAreNullableByDefault
public class BannerWithSystemFieldsMappings {

    private BannerWithSystemFieldsMappings() {
    }

    public static BannersStatusactive statusActiveToDb(Boolean statusActive) {
        if (statusActive == null) {
            return null;
        }
        return statusActive ? BannersStatusactive.Yes : BannersStatusactive.No;
    }

    public static Boolean statusActiveFromDb(BannersStatusactive statusActive) {
        return statusActive != null ? statusActive == BannersStatusactive.Yes : null;
    }

    public static BannersStatusarch statusArchivedToDb(Boolean statusArchived) {
        if (statusArchived == null) {
            return null;
        }
        return statusArchived ? BannersStatusarch.Yes : BannersStatusarch.No;
    }

    public static Boolean statusArchivedFromDb(BannersStatusarch statusArchived) {
        return statusArchived != null ? statusArchived == BannersStatusarch.Yes : null;
    }

    public static BannersStatusbssynced statusBsSyncedToDb(StatusBsSynced statusBsSynced) {
        return statusBsSynced != null ? BannersStatusbssynced.valueOf(statusBsSynced.toDbFormat()) : null;
    }

    public static StatusBsSynced statusBsSyncedFromDb(BannersStatusbssynced statusBsSynced) {
        return statusBsSynced != null ? StatusBsSynced.valueOfDbFormat(statusBsSynced.name()) : null;
    }

    public static BannersStatusshow statusShowToDb(Boolean statusShow) {
        if (statusShow == null) {
            return null;
        }
        return statusShow ? BannersStatusshow.Yes : BannersStatusshow.No;
    }

    public static Boolean statusShowFromDb(BannersStatusshow statusShow) {
        return statusShow != null ? statusShow == BannersStatusshow.Yes : null;
    }

    public static Language languageFromDb(BannersLanguage bannersLanguage) {
        return bannersLanguage == null ? null : Language.fromSource(bannersLanguage);
    }

    public static BannersLanguage languageToDb(Language language) {
        return language != null ? Language.toSource(language) : BannersLanguage.unknown;
    }
}
