package ru.yandex.direct.core.entity.banner.type.title;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstants;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;

@Service
public class BannerConstantsService {

    /**
     * Максимальная длина заголовка 1 без учёта вхождения шаблонных меток
     * {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL} (самостоятельный диез учитывается)
     */
    public static final int MAX_LENGTH_TITLE = 35;

    /**
     * Новая максимальная длина заголовка 1 без учёта вхождения шаблонных меток
     * {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL} (самостоятельный диез учитывается)
     */
    public static final int NEW_MAX_LENGTH_TITLE = 56;

    /**
     * Максимальная длина заголовка объявления продвижения контента без учёта вхождения шаблонных меток
     * {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL} (самостоятельный диез учитывается)
     */
    public static final int MAX_LENGTH_CONTENT_PROMOTION_TITLE = 200;

    /**
     * Максимальная длина заголовка объявления для видео на главной без учёта вхождения шаблонных меток
     * {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL} (самостоятельный диез учитывается)
     */
    public static final int MAX_LENGTH_VIDEO_FRONTPAGE_TITLE = 30;

    /**
     * Максимальная длина слова в заголовках баннера без учёта вхождения шаблонных меток
     * {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL} (самостоятельный диез учитывается)
     */
    public static final int MAX_LENGTH_TITLE_WORD = 22;

    /**
     * Значение title для mc banner'а
     */
    public static final String MC_BANNER_TITLE = "picture banner title";

    private final FeatureService featureService;

    @Autowired
    public BannerConstantsService(FeatureService featureService) {
        this.featureService = featureService;
    }

    public int getMaxLengthTitle(ClientId clientId) {
        return getMaxLengthTitle(clientId, FeatureName.INCREASE_AD_TEXT_LIMITS);
    }

    public int getMaxLengthUcTitle(ClientId clientId) {
        return getMaxLengthTitle(clientId, FeatureName.UNIVERSAL_CAMPAIGNS_INCREASE_AD_TEXT_LIMITS);
    }

    private int getMaxLengthTitle(ClientId clientId, FeatureName featureName) {
        return getMaxLengthTitle(featureService.isEnabledForClientId(clientId, featureName));
    }

    public int getMaxLengthTitle(boolean useNewLength) {
        return useNewLength ? NEW_MAX_LENGTH_TITLE : MAX_LENGTH_TITLE;
    }
}
