package ru.yandex.direct.core.entity.banner.type.title;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.banner.BannerTranslations;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedTitle;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.core.entity.banner.type.title.BannerConstantsService.MC_BANNER_TITLE;

@Component
public class BannerWithFixedTitleAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithFixedTitle> {

    private final TranslationService translationService;

    public BannerWithFixedTitleAddOperationTypeSupport(TranslationService translationService) {
        this.translationService = translationService;
    }

    @Override
    public Class<BannerWithFixedTitle> getTypeClass() {
        return BannerWithFixedTitle.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithFixedTitle> models) {
        models.forEach(banner -> banner.setTitle(generateTitle(banner)));
    }

    private String generateTitle(BannerWithFixedTitle banner) {
        if (banner instanceof DynamicBanner) {
            return translationService.translate(BannerTranslations.INSTANCE.dynamicTitle());
        } else if (banner instanceof PerformanceBanner || banner instanceof PerformanceBannerMain) {
            return translationService.translate(BannerTranslations.INSTANCE.performanceTitle());
        } else if (banner instanceof McBanner) {
            return MC_BANNER_TITLE;
        } else {
            throw new IllegalArgumentException("Unknown banner type");
        }
    }
}
