package ru.yandex.direct.core.entity.banner.type.title;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedTitle;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithFixedTitleAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithFixedTitle> {

    private final BannerWithFixedTitleValidatorProvider validatorProvider;

    @Autowired
    public BannerWithFixedTitleAddValidationTypeSupport(
            BannerWithFixedTitleValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithFixedTitle> getTypeClass() {
        return BannerWithFixedTitle.class;
    }

    @Override
    public ValidationResult<List<BannerWithFixedTitle>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithFixedTitle>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithFixedTitleAddValidator(container))
                .getResult();
    }
}
