package ru.yandex.direct.core.entity.banner.type.title;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedTitle;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithFixedTitleUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithFixedTitle> {

    private final BannerWithFixedTitleValidatorProvider validatorProvider;

    @Autowired
    public BannerWithFixedTitleUpdateValidationTypeSupport(
            BannerWithFixedTitleValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithFixedTitle> getTypeClass() {
        return BannerWithFixedTitle.class;
    }

    @Override
    public ValidationResult<List<BannerWithFixedTitle>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithFixedTitle>, Defect> vr,
            Map<Integer, AppliedChanges<BannerWithFixedTitle>> appliedChangesForValidModelChanges) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithFixedTitleUpdateValidator(appliedChangesForValidModelChanges))
                .getResult();
    }
}
