package ru.yandex.direct.core.entity.banner.type.title;

import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedTitle;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListItemValidator;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.validation.ValidationUtils.addErrorIfPropertyChanged;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@Component
public class BannerWithFixedTitleValidatorProvider {

    public Validator<BannerWithFixedTitle, Defect> bannerWithFixedTitleAddValidator(
            BannersAddOperationContainer container) {
        return banner -> {
            ModelItemValidationBuilder<BannerWithFixedTitle> vb = ModelItemValidationBuilder.of(banner);
            vb.item(BannerWithFixedTitle.TITLE)
                    .check(isNull());
            return vb.getResult();
        };
    }

    public ListItemValidator<BannerWithFixedTitle, Defect> bannerWithFixedTitleUpdateValidator(
            Map<Integer, AppliedChanges<BannerWithFixedTitle>> appliedChanges) {
        return (index, banner) -> {
            AppliedChanges<BannerWithFixedTitle> bannerChanges = appliedChanges.get(index);
            ModelItemValidationBuilder<BannerWithFixedTitle> vb = ModelItemValidationBuilder.of(banner);
            addErrorIfPropertyChanged(bannerChanges, vb, BannerWithFixedTitle.TITLE);
            return vb.getResult();
        };
    }
}
