package ru.yandex.direct.core.entity.banner.type.title;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitle;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithTitleAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithTitle> {

    private final BannerWithTitleValidatorProvider validatorProvider;

    @Autowired
    public BannerWithTitleAddValidationTypeSupport(BannerWithTitleValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithTitle> getTypeClass() {
        return BannerWithTitle.class;
    }

    @Override
    public ValidationResult<List<BannerWithTitle>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithTitle>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithTitleValidator(container))
                .getResult();
    }
}
