package ru.yandex.direct.core.entity.banner.type.title;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitleComputedFromCreative;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;
import ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeHelper;

@Component
public class BannerWithTitleComputedFromCreativeAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithTitleComputedFromCreative> {

    private final BannerWithCreativeHelper creativeHelper;

    @Autowired
    public BannerWithTitleComputedFromCreativeAddOperationTypeSupport(
            BannerWithCreativeHelper creativeHelper) {
        this.creativeHelper = creativeHelper;
    }

    @Override
    public Class<BannerWithTitleComputedFromCreative> getTypeClass() {
        return BannerWithTitleComputedFromCreative.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer container,
                                List<BannerWithTitleComputedFromCreative> banners) {
        setBannerTitlesFromCreatives(container, banners);
    }

    private void setBannerTitlesFromCreatives(BannersAddOperationContainer container,
                                              List<BannerWithTitleComputedFromCreative> banners) {
        Map<Long, String> creativeIdToModerationTitlesMap =
                creativeHelper.getCreativesModerationTitles(container.getShard(), banners);
        StreamEx.of(banners)
                .filter(banner -> banner.getCreativeId() != null)
                .forEach(banner ->
                        banner.setTitle(creativeIdToModerationTitlesMap.get(banner.getCreativeId())));
    }
}
