package ru.yandex.direct.core.entity.banner.type.title;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitleComputedFromCreative;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeHelper;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithTitle.TITLE;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class BannerWithTitleComputedFromCreativeUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithTitleComputedFromCreative> {

    private final BannerWithCreativeHelper creativeHelper;

    @Autowired
    public BannerWithTitleComputedFromCreativeUpdateOperationTypeSupport(
            BannerWithCreativeHelper creativeHelper) {
        this.creativeHelper = creativeHelper;
    }

    @Override
    public Class<BannerWithTitleComputedFromCreative> getTypeClass() {
        return BannerWithTitleComputedFromCreative.class;
    }

    @Override
    public void beforeExecution(BannersUpdateOperationContainer container,
                                List<AppliedChanges<BannerWithTitleComputedFromCreative>> changesList) {
        setBannerTitlesFromCreatives(container, changesList);
    }

    private void setBannerTitlesFromCreatives(
            BannersUpdateOperationContainer container,
            List<AppliedChanges<BannerWithTitleComputedFromCreative>> changesList) {
        List<BannerWithCreative> banners = mapList(changesList, AppliedChanges::getModel);
        Map<Long, String> creativeIdToModerationTitlesMap =
                creativeHelper.getCreativesModerationTitles(container.getShard(), banners);
        StreamEx.of(changesList)
                .filter(changes -> changes.getModel().getCreativeId() != null)
                .forEach(changes ->
                        changes.modify(TITLE, creativeIdToModerationTitlesMap.get(changes.getModel().getCreativeId())));
    }
}
