package ru.yandex.direct.core.entity.banner.type.title;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitle;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.core.entity.banner.repository.type.ModifiedPaths;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.grut.objects.proto.client.Schema;

import static java.util.Collections.emptySet;
import static java.util.function.Function.identity;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithTitleRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithTitle> {

    @Autowired
    public BannerWithTitleRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithTitle.TITLE, BANNERS.TITLE, identity(), identity());
    }

    @Override
    public Class<BannerWithTitle> getTypeClass() {
        return BannerWithTitle.class;
    }

    @Override
    public Set<ModelProperty<? super BannerWithTitle, ?>> getGrutSupportedProperties() {
        return Set.of(BannerWithTitle.TITLE);
    }

    @Override
    public Map<Long, ModifiedPaths> applyToGrutObjects(@NotNull Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
                                                       @NotNull Collection<AppliedChanges<BannerWithTitle>> appliedChangesList,
                                                       @NotNull BannersOperationContainer operationContainer) {
        Map<Long, ModifiedPaths> modifiedPathsMap = new HashMap<>();
        for (AppliedChanges<BannerWithTitle> appliedChanges : appliedChangesList) {
            if (appliedChanges.getPropertiesForUpdate().contains(BannerWithTitle.TITLE)) {
                Long id = appliedChanges.getModel().getId();
                Schema.TBannerV2.Builder bannerBuilder = bannerBuilders.get(id);
                ModifiedPaths modifiedPaths;
                String newValue = appliedChanges.getNewValue(BannerWithTitle.TITLE);
                if (newValue != null) {
                    bannerBuilder.getSpecBuilder().setTitle(newValue);
                    modifiedPaths = new ModifiedPaths(Set.of("/spec/title"), emptySet());
                } else {
                    modifiedPaths = new ModifiedPaths(emptySet(), Set.of("/spec/title"));
                }
                modifiedPathsMap.put(id, modifiedPaths);
            }
        }
        return modifiedPathsMap;
    }
}
