package ru.yandex.direct.core.entity.banner.type.title;


import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersModerationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitle;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerTextChangeUtil.isBannerTitleChangedSignificantly;

@Component
public class BannerWithTitleUpdateOperationTypeSupport extends AbstractBannerUpdateOperationTypeSupport<BannerWithTitle> {

    @Override
    public Class<BannerWithTitle> getTypeClass() {
        return BannerWithTitle.class;
    }

    @Override
    public boolean needModeration(BannersModerationContainer container,
                                  AppliedChanges<BannerWithTitle> appliedChanges) {
        return isBannerTitleChangedSignificantly(appliedChanges);
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithTitle> appliedChanges) {
        return appliedChanges.changed(BannerWithTitle.TITLE);
    }
}
