package ru.yandex.direct.core.entity.banner.type.titleextension;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitleExtension;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.core.entity.banner.repository.type.ModifiedPaths;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.grut.objects.proto.client.Schema;

import static java.util.Collections.emptySet;
import static java.util.function.Function.identity;
import static org.apache.commons.lang3.StringUtils.isEmpty;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithTitleExtensionRepositoryTypeSupport extends
        AbstractBannerDefaultRepositoryTypeSupport<BannerWithTitleExtension> {

    public static final Set<ModelProperty<? super BannerWithTitleExtension, ?>> GRUT_PROPERTIES =
            Set.of(BannerWithTitleExtension.TITLE_EXTENSION);

    @Autowired
    public BannerWithTitleExtensionRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithTitleExtension.TITLE_EXTENSION, BANNERS.TITLE_EXTENSION,
                BannerWithTitleExtensionRepositoryTypeSupport::titleExtensionReadConverter, identity());
    }

    @Nullable
    private static String titleExtensionReadConverter(String titleExtension) {
        return isEmpty(titleExtension) ? null : titleExtension;
    }

    @Override
    public Class<BannerWithTitleExtension> getTypeClass() {
        return BannerWithTitleExtension.class;
    }

    @Override
    public Set<ModelProperty<? super BannerWithTitleExtension, ?>> getGrutSupportedProperties() {
        return GRUT_PROPERTIES;
    }

    @Override
    public Map<Long, ModifiedPaths> applyToGrutObjects(
            @NotNull Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
            @NotNull Collection<AppliedChanges<BannerWithTitleExtension>> appliedChangesList,
            @NotNull BannersOperationContainer operationContainer) {
        Map<Long, ModifiedPaths> modifiedPathsMap = new HashMap<>();
        for (AppliedChanges<BannerWithTitleExtension> appliedChanges : appliedChangesList) {
            if (appliedChanges.getPropertiesForUpdate().contains(BannerWithTitleExtension.TITLE_EXTENSION)) {
                Long id = appliedChanges.getModel().getId();
                Schema.TBannerV2.Builder bannerBuilder = bannerBuilders.get(id);
                ModifiedPaths modifiedPaths;
                String newValue = appliedChanges.getNewValue(BannerWithTitleExtension.TITLE_EXTENSION);
                if (newValue != null) {
                    bannerBuilder.getSpecBuilder().setTitleExtension(newValue);
                    modifiedPaths = new ModifiedPaths(Set.of("/spec/title_extension"), emptySet());
                } else {
                    modifiedPaths = new ModifiedPaths(emptySet(), Set.of("/spec/title_extension"));
                }
                modifiedPathsMap.put(id, modifiedPaths);
            }
        }
        return modifiedPathsMap;
    }
}
