package ru.yandex.direct.core.entity.banner.type.titleextension;


import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersModerationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitleExtension;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerTextChangeUtil.isBannerTitleExtensionChangedSignificantly;

@Component
public class BannerWithTitleExtensionUpdateOperationTypeSupport extends AbstractBannerUpdateOperationTypeSupport<BannerWithTitleExtension> {

    @Override
    public Class<BannerWithTitleExtension> getTypeClass() {
        return BannerWithTitleExtension.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithTitleExtension> appliedChanges) {
        return appliedChanges.changed(BannerWithTitleExtension.TITLE_EXTENSION);
    }

    @Override
    public boolean needModeration(BannersModerationContainer container,
                                  AppliedChanges<BannerWithTitleExtension> appliedChanges) {
        return isBannerTitleExtensionChangedSignificantly(appliedChanges);
    }
}
