package ru.yandex.direct.core.entity.banner.type.titleextension;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitleExtension;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithTitleExtensionUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithTitleExtension> {

    private final BannerWithTitleExtensionValidatorProvider validatorProvider;

    @Autowired
    public BannerWithTitleExtensionUpdateValidationTypeSupport(
            BannerWithTitleExtensionValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithTitleExtension> getTypeClass() {
        return BannerWithTitleExtension.class;
    }

    @Override
    public ValidationResult<List<BannerWithTitleExtension>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithTitleExtension>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithTitleExtensionValidator())
                .getResult();
    }
}
