package ru.yandex.direct.core.entity.banner.type.titleextension;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithTitleExtension;
import ru.yandex.direct.core.entity.banner.service.validation.BannerTextValidator;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstants.MAX_NUMBER_OF_NARROW_CHARACTERS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.absentValueInField;
import static ru.yandex.direct.core.entity.banner.type.title.BannerConstantsService.MAX_LENGTH_TITLE_WORD;
import static ru.yandex.direct.core.entity.banner.type.titleextension.BannerWithTitleExtensionConstants.MAX_LENGTH_TITLE_EXTENSION;

@Component
public class BannerWithTitleExtensionValidatorProvider {

    public Validator<BannerWithTitleExtension, Defect> bannerWithTitleExtensionValidator() {

        return bannerWithTitleExtension -> {
            ModelItemValidationBuilder<BannerWithTitleExtension> ivb =
                    ModelItemValidationBuilder.of(bannerWithTitleExtension);

            ivb.item(BannerWithTitleExtension.TITLE_EXTENSION)
                    .checkBy(titleExtensionValidator(), When.notNull());

            return ivb.getResult();
        };
    }

    public Validator<String, Defect> titleExtensionValidator() {
        return BannerTextValidator
                .builder(MAX_LENGTH_TITLE_EXTENSION, MAX_LENGTH_TITLE_WORD)
                .withMaxNumberOfNarrowCharacters(MAX_NUMBER_OF_NARROW_CHARACTERS)
                .withStringIsNotBlankDefect(absentValueInField())
                .build();
    }
}
