package ru.yandex.direct.core.entity.banner.type.tns;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_TNS;

@Repository
@ParametersAreNonnullByDefault
public class BannerTnsRepository {

    /**
     * Удаление tns по id баннеров
     *
     * @param context   контекст
     * @param bannerIds список id баннеров
     */
    public void deleteBannerTnsByBannerIds(DSLContext context, Collection<Long> bannerIds) {
        if (bannerIds.isEmpty()) {
            return;
        }
        context.deleteFrom(BANNERS_TNS)
                .where(BANNERS_TNS.BID.in(bannerIds))
                .execute();
    }

}
