package ru.yandex.direct.core.entity.banner.type.tns;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.restrictedCharsInField;
import static ru.yandex.direct.core.entity.banner.type.tns.BannerWithTnsConstants.TNS_ALLOWED_REGEX;
import static ru.yandex.direct.core.entity.banner.type.tns.BannerWithTnsConstants.TNS_ID_MAX_LENGTH;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

@ParametersAreNonnullByDefault
public class BannerTnsValidator implements DefaultValidator<String> {

    private final CampaignType campaignType;

    public BannerTnsValidator(CampaignType campaignType) {
        this.campaignType = campaignType;
    }

    @Override
    public ValidationResult<String, Defect> apply(@Nullable String tnsId) {
        ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(tnsId);

        if (campaignType == CampaignType.CPM_PRICE) {
            builder.check(isNull());
        } else {
            builder
                    .check(notBlank())
                    .check(fromPredicate(tns -> tns.matches(TNS_ALLOWED_REGEX), restrictedCharsInField()),
                            When.isValid())
                    .check(maxStringLength(TNS_ID_MAX_LENGTH), When.isValid());
        }

        return builder.getResult();
    }
}
