package ru.yandex.direct.core.entity.banner.type.tns;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTns;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithTnsAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithTns> {

    private final BannerWithTnsValidatorProvider validatorProvider;

    @Autowired
    public BannerWithTnsAddValidationTypeSupport(BannerWithTnsValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithTns> getTypeClass() {
        return BannerWithTns.class;
    }

    @Override
    public ValidationResult<List<BannerWithTns>, Defect> validate(BannersAddOperationContainer container,
                                                                  ValidationResult<List<BannerWithTns>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.tnsValidator(container))
                .getResult();
    }


}
