package ru.yandex.direct.core.entity.banner.type.tns;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithTns;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractRelatedSingleFieldRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersTnsRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_TNS;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTnsRepositoryTypeSupport extends
        AbstractRelatedSingleFieldRepositoryTypeSupport<BannerWithTns, String, BannersTnsRecord, String> {

    @Autowired
    public BannerWithTnsRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider,
                BannerWithTns.TNS_ID,
                BANNERS_TNS.BID,
                BANNERS_TNS.TNS_ID,
                Function.identity(),
                Function.identity());
    }

    @Override
    public Class<BannerWithTns> getTypeClass() {
        return BannerWithTns.class;
    }
}
