package ru.yandex.direct.core.entity.banner.type.tns;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTns;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;


@Component
public class BannerWithTnsValidatorProvider {

    public Validator<BannerWithTns, Defect> tnsValidator(BannersOperationContainer container) {
        return bannerWithTns -> {
            CampaignType campaignType = ifNotNull(container.getCampaign(bannerWithTns), CommonCampaign::getType);

            ModelItemValidationBuilder<BannerWithTns> ivb = ModelItemValidationBuilder.of(bannerWithTns);
            ivb.item(BannerWithTns.TNS_ID)
                    .checkBy(tnsValidator(campaignType));
            return ivb.getResult();
        };
    }

    private Validator<String, Defect> tnsValidator(CampaignType campaignType) {

        return tnsId -> {
            ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(tnsId);
            builder.checkBy(new BannerTnsValidator(campaignType));
            return builder.getResult();
        };

    }
}
