package ru.yandex.direct.core.entity.banner.type.turboapp;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.BannerTurboApps.BANNER_TURBO_APPS;

@Repository
@ParametersAreNonnullByDefault
public class BannerTurboAppsRepository {

    private final DslContextProvider ppcDslContextProvider;

    @Autowired
    public BannerTurboAppsRepository(DslContextProvider ppcDslContextProvider) {
        this.ppcDslContextProvider = ppcDslContextProvider;
    }

    public Set<Long> getExistedBidsWithTurboApps(int shard, Collection<Long> bannerIds) {
        return ppcDslContextProvider.ppc(shard)
                .select(BANNER_TURBO_APPS.BID)
                .from(BANNER_TURBO_APPS)
                .where(BANNER_TURBO_APPS.BID.in(bannerIds))
                .fetchSet(BANNER_TURBO_APPS.BID);
    }

    /**
     * Удаляет турбо-аппы по списку баннеров
     */
    public void deleteBannerTurboApps(int shard, Collection<Long> bannerIds) {
        ppcDslContextProvider.ppc(shard)
                .deleteFrom(BANNER_TURBO_APPS)
                .where(BANNER_TURBO_APPS.BID.in(bannerIds)).execute();
    }

}
