package ru.yandex.direct.core.entity.banner.type.turboapp;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndPriceAndTurboApp;
import ru.yandex.direct.core.entity.banner.model.TurboAppInfo;
import ru.yandex.direct.core.entity.banner.service.BannerTurboAppService;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.turboapps.client.model.TurboAppInfoResponse;

import static ru.yandex.direct.core.entity.banner.type.turboapp.BannerWithHrefAndPriceAndTurboAppUtils.countBannerTurboAppType;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class BannerWithHrefAndPriceAndTurboAppAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithHrefAndPriceAndTurboApp> {

    private final BannerTurboAppService bannerTurboAppService;

    @Autowired
    public BannerWithHrefAndPriceAndTurboAppAddOperationTypeSupport(BannerTurboAppService bannerTurboAppService) {
        this.bannerTurboAppService = bannerTurboAppService;
    }

    @Override
    public Class<BannerWithHrefAndPriceAndTurboApp> getTypeClass() {
        return BannerWithHrefAndPriceAndTurboApp.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer,
                                List<BannerWithHrefAndPriceAndTurboApp> models) {
        if (addContainer.isFeatureEnabledForClient(FeatureName.TURBO_APP_ALLOWED)) {
            var bannersWithTurboAppsAllowed = filterList(models,
                    banner -> addContainer.getCampaign(banner).getHasTurboApp());

            addBannerTurboApps(addContainer.getShard(), addContainer.getClientId(), bannersWithTurboAppsAllowed);
        }
    }

    public void addBannerTurboApps(int shard, ClientId clientId, List<BannerWithHrefAndPriceAndTurboApp> banners) {
        if (banners.isEmpty()) {
            return;
        }

        // Используем индекс баннера как ключ, потому что bid еще не сгенерирован
        Map<Long, String> bannerHrefByIndex = EntryStream.of(banners)
                .mapKeys(Long::valueOf)
                .mapValues(BannerWithHrefAndPriceAndTurboApp::getHref)
                .filterValues(Objects::nonNull)
                .toMap();

        Map<Long, TurboAppInfoResponse> turboAppsResponse = bannerTurboAppService.getTurboAppsInfo(bannerHrefByIndex);

        Map<Long, TurboAppInfo> turboAppByAppId = bannerTurboAppService
                .upsertTurboApps(shard, clientId, turboAppsResponse.values());

        Map<Long, TurboAppInfo> turboAppByBannerIndex = EntryStream.of(turboAppsResponse)
                .mapValues(TurboAppInfoResponse::getAppId)
                .mapValues(turboAppByAppId::get)
                .toMap();

        EntryStream.of(banners)
                .mapKeys(Long::valueOf)
                .filterKeys(turboAppsResponse::containsKey)
                .forKeyValue((index, banner) -> {
                    TurboAppInfo turboApp = turboAppByBannerIndex.get(index);
                    TurboAppInfoResponse turboAppResponse = turboAppsResponse.get(index);

                    banner.withTurboAppInfoId(turboApp.getTurboAppInfoId())
                            .withTurboAppContent(turboAppResponse.getContent())
                            .withTurboAppType(countBannerTurboAppType(banner.getBannerPrice()));
                });
    }

}
