package ru.yandex.direct.core.entity.banner.type.turboapp;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerTurboAppType;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboApp;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityUpsertRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerTurboAppsRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.turboapp.BannerWithTurboAppConstants.NEW_BANNER_TURBO_APP_PROPERTIES;
import static ru.yandex.direct.dbschema.ppc.tables.BannerTurboApps.BANNER_TURBO_APPS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboAppRepositoryTypeSupport
        extends AbstractFlatRelatedEntityUpsertRepositoryTypeSupport
        <BannerWithTurboApp, BannerTurboAppsRecord> {

    protected BannerWithTurboAppRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNER_TURBO_APPS.BID, createMapper());
    }

    private static JooqMapper<BannerWithTurboApp> createMapper() {
        return JooqMapperBuilder.<BannerWithTurboApp>builder()
                .map(property(BannerWithTurboApp.TURBO_APP_INFO_ID, BANNER_TURBO_APPS.TURBO_APP_INFO_ID))
                .map(property(BannerWithTurboApp.TURBO_APP_CONTENT, BANNER_TURBO_APPS.CONTENT))
                .map(convertibleProperty(BannerWithTurboApp.TURBO_APP_TYPE, BANNER_TURBO_APPS.BANNER_TURBO_APP_TYPE,
                        BannerTurboAppType::fromSource,
                        BannerTurboAppType::toSource))
                .writeField(BANNER_TURBO_APPS.BID, fromProperty(BannerWithTurboApp.ID))
                .build();
    }

    @Override
    protected void upsertEntity(DSLContext context, Collection<BannerWithTurboApp> banners) {
        var insertHelper = new InsertHelper<>(context, BANNER_TURBO_APPS);
        insertHelper.addAll(getJooqMapper(), banners);
        insertHelper.onDuplicateKeyUpdate()
                .set(BANNER_TURBO_APPS.TURBO_APP_INFO_ID, MySQLDSL.values(BANNER_TURBO_APPS.TURBO_APP_INFO_ID))
                .set(BANNER_TURBO_APPS.CONTENT, MySQLDSL.values(BANNER_TURBO_APPS.CONTENT))
                .set(BANNER_TURBO_APPS.BANNER_TURBO_APP_TYPE, MySQLDSL.values(BANNER_TURBO_APPS.BANNER_TURBO_APP_TYPE));
        insertHelper.executeIfRecordsAdded();
    }

    @Override
    protected boolean isAddEntity(BannerWithTurboApp model) {
        return model.getTurboAppInfoId() != null;
    }

    @Override
    protected boolean isUpsertEntity(AppliedChanges<BannerWithTurboApp> ac) {
        return !isDeleteEntity(ac) && NEW_BANNER_TURBO_APP_PROPERTIES.stream().anyMatch(ac::changed);
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<BannerWithTurboApp> appliedChange) {
        return appliedChange.deleted(BannerWithTurboApp.TURBO_APP_INFO_ID);
    }

    @Override
    public Class<BannerWithTurboApp> getTypeClass() {
        return BannerWithTurboApp.class;
    }
}
