package ru.yandex.direct.core.entity.banner.type.turboapp;

import ru.yandex.direct.core.entity.banner.model.BannerWithTurboApp;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.turboapp.BannerWithTurboAppConstants.NEW_BANNER_TURBO_APP_PROPERTIES;

public class BannerWithTurboAppUpdateOperationTypeSupport extends AbstractBannerUpdateOperationTypeSupport<BannerWithTurboApp> {

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithTurboApp> appliedChanges) {
        return NEW_BANNER_TURBO_APP_PROPERTIES.stream().anyMatch(appliedChanges::changed);
    }

    @Override
    public Class<BannerWithTurboApp> getTypeClass() {
        return BannerWithTurboApp.class;
    }
}
