package ru.yandex.direct.core.entity.banner.type.turbogallery;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.BannerTurboGalleries.BANNER_TURBO_GALLERIES;

@Repository
public class BannerTurboGalleriesRepository {

    private final DslContextProvider dslContextProvider;
    private final ShardHelper shardHelper;

    @Autowired
    public BannerTurboGalleriesRepository(DslContextProvider dslContextProvider, ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.shardHelper = shardHelper;
    }

    public Map<Long, String> getAllTurboGalleries() {
        Map<Long, String> result = new HashMap<>();
        shardHelper.forEachShard(shard -> result.putAll(getAllTurboGalleries(shard)));
        return result;
    }

    private Map<Long, String> getAllTurboGalleries(int shard) {
        return dslContextProvider.ppc(shard)
                .select(BANNER_TURBO_GALLERIES.BID, BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF)
                .from(BANNER_TURBO_GALLERIES)
                .fetchMap(BANNER_TURBO_GALLERIES.BID, BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF);
    }

    public Map<Long, String> getTurboGalleriesByBannerIds(int shard, Collection<Long> bannerIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNER_TURBO_GALLERIES.BID, BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF)
                .from(BANNER_TURBO_GALLERIES)
                .where(BANNER_TURBO_GALLERIES.BID.in(bannerIds))
                .fetchMap(BANNER_TURBO_GALLERIES.BID, BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF);
    }
}
