package ru.yandex.direct.core.entity.banner.type.turbogallery;

import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.invalidHref;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

@ParametersAreNonnullByDefault
public class BannerTurboGalleryConstraints {
    /**
     * Максимальная длина ссылки на турбо-галерею
     */
    public static final int MAX_LENGTH_TURBO_GALLERY_HREF = 1024;

    /**
     * Паттерн для проверки ссылки на турбо-галерею
     */
    public static final Pattern TURBO_GALLERY_URL_PATTERN = Pattern.compile("^https?://yandex.ru/turbo\\S*$");

    /**
     * Проверка валидности ссылки на Турбо-галерею
     */
    public static Constraint<String, Defect> validTurboGalleryHref() {
        return fromPredicate(href -> TURBO_GALLERY_URL_PATTERN.matcher(href).matches(), invalidHref());
    }
}
