package ru.yandex.direct.core.entity.banner.type.turbogallery;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithTurboGallery;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractRelatedSingleFieldRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerTurboGalleriesRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBO_GALLERIES;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboGalleryRepositoryTypeSupport extends AbstractRelatedSingleFieldRepositoryTypeSupport<
        BannerWithTurboGallery, String, BannerTurboGalleriesRecord, String> {
    @Autowired
    public BannerWithTurboGalleryRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider,
                BannerWithTurboGallery.TURBO_GALLERY_HREF,
                BANNER_TURBO_GALLERIES.BID,
                BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF,
                Function.identity(),
                Function.identity());
    }

    @Override
    public Class getTypeClass() {
        return BannerWithTurboGallery.class;
    }
}
