package ru.yandex.direct.core.entity.banner.type.turbogallery;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithTurboGallery;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithTurboGallery.TURBO_GALLERY_HREF;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboGalleryUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithTurboGallery> {
    @Override
    public Class<BannerWithTurboGallery> getTypeClass() {
        return BannerWithTurboGallery.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithTurboGallery> appliedChanges) {
        return appliedChanges.changed(TURBO_GALLERY_HREF);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithTurboGallery> appliedChanges) {
        return appliedChanges.changed(TURBO_GALLERY_HREF);
    }
}
