package ru.yandex.direct.core.entity.banner.type.turbogallery;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboGallery;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboGalleryUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithTurboGallery> {

    private final BannerWithTurboGalleryValidatorProvider validatorProvider;

    @Autowired
    public BannerWithTurboGalleryUpdateValidationTypeSupport(
            BannerWithTurboGalleryValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithTurboGallery> getTypeClass() {
        return BannerWithTurboGallery.class;
    }

    @Override
    public ValidationResult<List<BannerWithTurboGallery>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithTurboGallery>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithTurboGalleryValidator())
                .getResult();
    }
}
