package ru.yandex.direct.core.entity.banner.type.turbogallery;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithTurboGallery;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.hrefIsNotBlank;
import static ru.yandex.direct.core.entity.banner.type.turbogallery.BannerTurboGalleryConstraints.MAX_LENGTH_TURBO_GALLERY_HREF;
import static ru.yandex.direct.core.entity.banner.type.turbogallery.BannerTurboGalleryConstraints.validTurboGalleryHref;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboGalleryValidatorProvider {
    public Validator<BannerWithTurboGallery, Defect> bannerWithTurboGalleryValidator() {
        return bannerWithTurboGallery -> {
            ModelItemValidationBuilder<BannerWithTurboGallery> ivb =
                    ModelItemValidationBuilder.of(bannerWithTurboGallery);

            ivb.item(BannerWithTurboGallery.TURBO_GALLERY_HREF).checkBy(turboGalleryHrefValidator());

            return ivb.getResult();
        };
    }

    public static Validator<String, Defect> turboGalleryHrefValidator() {
        return turboGalleryHref -> ItemValidationBuilder.<String, Defect>of(turboGalleryHref)
                .check(hrefIsNotBlank())
                .check(maxStringLength(MAX_LENGTH_TURBO_GALLERY_HREF), When.isValid())
                .check(validTurboGalleryHref(), When.isValid())
                .getResult();
    }
}
