package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.Map;

import one.util.streamex.EntryStream;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.BannerTurboLandingStatusModerate;
import ru.yandex.direct.dbschema.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;

@Repository
public class BannerTurboLandingRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public BannerTurboLandingRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Обновляет статусы модерации связок турболендингов с баннерами
     *
     * @param statusModerateByBannerId Соответствие статуса модерации связки id баннера
     */
    public void updateBannerTurbolandingsStatusModerate(
            int shard, Map<Long, BannerTurboLandingStatusModerate> statusModerateByBannerId) {
        updateBannerTurbolandingsStatusModerate(dslContextProvider.ppc(shard).configuration(),
                statusModerateByBannerId);
    }

    /**
     * Обновляет статусы модерации связок турболендингов с баннерами
     *
     * @param statusModerateByBannerId Соответствие статуса модерации связки id баннера
     */
    public void updateBannerTurbolandingsStatusModerate(
            Configuration configuration, Map<Long, BannerTurboLandingStatusModerate> statusModerateByBannerId) {
        if (statusModerateByBannerId.isEmpty()) {
            return;
        }
        Field<BannerTurbolandingsStatusmoderate> statusModerateValues = DSL.choose(BANNER_TURBOLANDINGS.BID)
                .mapValues(EntryStream.of(statusModerateByBannerId)
                        .mapValues(BannerTurboLandingStatusModerate::toSource)
                        .toMap())
                .otherwise(BANNER_TURBOLANDINGS.STATUS_MODERATE);

        configuration.dsl()
                .update(BANNER_TURBOLANDINGS)
                .set(BANNER_TURBOLANDINGS.STATUS_MODERATE, statusModerateValues)
                .where(BANNER_TURBOLANDINGS.BID.in(statusModerateByBannerId.keySet()))
                .execute();
    }
}
