package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.Collection;
import java.util.Map;

import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;
import ru.yandex.direct.dbschema.ppc.enums.TurbolandingsPreset;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.turbolanding.BannerWithTurboLandingConstraints.turboLandingExists;
import static ru.yandex.direct.core.entity.banner.type.turbolanding.BannerWithTurboLandingConstraints.turboLandingPresetValid;

public class BannerTurboLandingValidator implements Validator<Long, Defect> {

    private final Collection<TurbolandingsPreset> validPresets;
    private final Map<Long, TurboLanding> existingTurboLandings;

    public BannerTurboLandingValidator(Collection<TurbolandingsPreset> validPresets,
                                          Map<Long, TurboLanding> existingTurboLandings) {
        this.validPresets = validPresets;
        this.existingTurboLandings = existingTurboLandings;
    }

    @Override
    public ValidationResult<Long, Defect> apply(Long turboLandingId) {
        ItemValidationBuilder<Long, Defect> builder = ItemValidationBuilder.of(turboLandingId);
        builder
                .check(turboLandingExists(existingTurboLandings.keySet()))
                .check(turboLandingPresetValid(existingTurboLandings.get(turboLandingId), validPresets),
                        When.isValid());

        return builder.getResult();
    }
}
