package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndTurboLanding;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithHrefAndTurboLandingAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithHrefAndTurboLanding> {

    private final BannerWithHrefAndTurboLandingValidatorProvider validatorProvider;

    @Autowired
    public BannerWithHrefAndTurboLandingAddValidationTypeSupport(
            BannerWithHrefAndTurboLandingValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithHrefAndTurboLanding> getTypeClass() {
        return BannerWithHrefAndTurboLanding.class;
    }

    @Override
    public ValidationResult<List<BannerWithHrefAndTurboLanding>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithHrefAndTurboLanding>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.hrefWithTurboValidator(container))
                .getResult();
    }
}
