package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndTurboLandingAndVcardAndOrganization;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithHrefAndTurboLandingAndVcardAndOrganizationAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithHrefAndTurboLandingAndVcardAndOrganization> {

    private final BannerWithHrefAndTurboLandingAndVcardAndOrganizationValidatorProvider validatorProvider;

    @Autowired
    public BannerWithHrefAndTurboLandingAndVcardAndOrganizationAddValidationTypeSupport(
            BannerWithHrefAndTurboLandingAndVcardAndOrganizationValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithHrefAndTurboLandingAndVcardAndOrganization> getTypeClass() {
        return BannerWithHrefAndTurboLandingAndVcardAndOrganization.class;
    }

    @Override
    public ValidationResult<List<BannerWithHrefAndTurboLandingAndVcardAndOrganization>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithHrefAndTurboLandingAndVcardAndOrganization>, Defect> vr) {
        if (container.isPartOfComplexOperation()) {
            return vr;
        }

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithHrefAndTurboLandingAndVcardAndOrganizationValidator(container))
                .getResult();
    }
}
