package ru.yandex.direct.core.entity.banner.type.turbolanding;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndTurboLandingAndVcardAndOrganization;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.type.turbolanding.BannerWithTurboLandingConstraints.hrefOrTurboLandingOrVcardOrOrganizationIsSet;

@Component
public class BannerWithHrefAndTurboLandingAndVcardAndOrganizationValidatorProvider {

    public Validator<BannerWithHrefAndTurboLandingAndVcardAndOrganization, Defect>
    bannerWithHrefAndTurboLandingAndVcardAndOrganizationValidator(BannersOperationContainer container) {
        return banner -> {
            ModelItemValidationBuilder<BannerWithHrefAndTurboLandingAndVcardAndOrganization> builder =
                    ModelItemValidationBuilder.of(banner);

            builder.check(hrefOrTurboLandingOrVcardOrOrganizationIsSet(
                    container.isFeatureEnabledForClient(FeatureName.DESKTOP_LANDING)));

            return builder.getResult();
        };
    }
}
