package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndTurboLanding;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithHrefAndTurboLandingUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithHrefAndTurboLanding> {

    private final BannerWithHrefAndTurboLandingValidatorProvider validatorProvider;

    @Autowired
    public BannerWithHrefAndTurboLandingUpdateValidationTypeSupport(
            BannerWithHrefAndTurboLandingValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithHrefAndTurboLanding> getTypeClass() {
        return BannerWithHrefAndTurboLanding.class;
    }

    @Override
    public ValidationResult<List<BannerWithHrefAndTurboLanding>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithHrefAndTurboLanding>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.hrefWithTurboValidator(container))
                .getResult();
    }
}
