package ru.yandex.direct.core.entity.banner.type.turbolanding;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndTurboLanding;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.service.validation.BannerConstraints;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.adgroup.model.AdGroupType.CPM_GEOPRODUCT;
import static ru.yandex.direct.core.entity.banner.model.BannerWithHref.HREF;
import static ru.yandex.direct.core.entity.campaign.model.CampaignType.CPM_PRICE;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class BannerWithHrefAndTurboLandingValidatorProvider {

    public Validator<BannerWithHrefAndTurboLanding, Defect> hrefWithTurboValidator(
            BannersOperationContainer container) {
        return bannerWithHrefAndTurbo -> {

            AdGroupType adGroupType = ifNotNull(container.getAdGroup(bannerWithHrefAndTurbo),
                    AdGroupForBannerOperation::getType);

            if (bannerWithHrefAndTurbo instanceof CpmBanner) {
                ModelItemValidationBuilder<BannerWithHrefAndTurboLanding> builder =
                        ModelItemValidationBuilder.of(bannerWithHrefAndTurbo);

                CampaignType campaignType = ifNotNull(container.getCampaign(bannerWithHrefAndTurbo),
                        CommonCampaign::getType);
                // 1. Для CPM_GEOPRODUCT есть отдельные проверки на href и turbo в
                //    BannerWithTurboLandingValidatorProvider и BannerWithHrefValidatorProvider, поэтому здесь
                //    ничего проверять не надо, чтобы не было повторных дефектов.
                // 2. Для прайсовых есть проверка в BannerWithHrefValidatorProvider, что href notNull, поэтому
                //    ничего дополнительного проверять не нужно.
                builder.check(BannerConstraints.hrefOrTurboIsSet(), When.isTrue(
                        adGroupType != CPM_GEOPRODUCT && campaignType != CPM_PRICE));

                return builder.getResult();
            } else {
                ModelItemValidationBuilder<BannerWithHrefAndTurboLanding> builder =
                        ModelItemValidationBuilder.of(bannerWithHrefAndTurbo);

                boolean isMobileAppBanner = AdGroupType.MOBILE_CONTENT == adGroupType;
                boolean turbolandingIsAbsent = bannerWithHrefAndTurbo.getTurboLandingId() == null;
                builder.item(HREF)
                        .check(notNull(), When.isTrue(!isMobileAppBanner && turbolandingIsAbsent));

                return builder.getResult();
            }
        };
    }
}
