package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerTurboLandingStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLanding;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;
import ru.yandex.direct.core.entity.creative.model.Creative;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.isEffectiveSaveDraft;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeUtils.isOverlayBanner;

@Component
public class BannerWithTurboLandingAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithTurboLanding> {

    @Override
    public Class<BannerWithTurboLanding> getTypeClass() {
        return BannerWithTurboLanding.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithTurboLanding> models) {
        models.stream()
                .filter(b -> b.getTurboLandingId() != null)
                .forEach(banner -> banner.setTurboLandingStatusModerate(turboLandingStatusModerate(addContainer, banner)));
    }

    private static BannerTurboLandingStatusModerate turboLandingStatusModerate(BannersAddOperationContainer container,
                                                                               BannerWithTurboLanding banner) {
        var adGroup = container.getAdGroup(banner);
        if (adGroup.getType() == AdGroupType.CPM_GEOPRODUCT && container.isCpmGeoProductAutoModeration()) {
            return BannerTurboLandingStatusModerate.YES;
        }
        // Оверлейные баннеры не отправляем на модерацию
        if (isOverlayBannerWithTurboLanding(banner, container.getCreativeByIdMap())) {
            return BannerTurboLandingStatusModerate.YES;
        }
        var effectiveSaveDraft = isEffectiveSaveDraft(container, banner);
        return effectiveSaveDraft ? BannerTurboLandingStatusModerate.NEW : BannerTurboLandingStatusModerate.READY;
    }

    private static boolean isOverlayBannerWithTurboLanding(BannerWithTurboLanding banner,
                                                           Map<Long, Creative> cpmBannerCreatives) {
        if(banner instanceof BannerWithCreative) {
            BannerWithCreative bannerWithCreative = (BannerWithCreative) banner;
            return isOverlayBanner(bannerWithCreative, cpmBannerCreatives);
        }
        return false;
    }
}
