package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLanding;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithTurboLandingAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithTurboLanding> {

    private final BannerWithTurboLandingValidatorProvider validatorProvider;

    @Autowired
    public BannerWithTurboLandingAddValidationTypeSupport(
            BannerWithTurboLandingValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithTurboLanding> getTypeClass() {
        return BannerWithTurboLanding.class;
    }

    @Override
    public ValidationResult<List<BannerWithTurboLanding>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithTurboLanding>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithTurboLandingValidator(container, vr.getValue()))
                .getResult();
    }
}
