package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.Collection;

import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndTurboLandingAndVcardAndOrganization;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;
import ru.yandex.direct.dbschema.ppc.enums.TurbolandingsPreset;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.inconsistentStateBannerTypeAndTurbolandingType;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.requiredButEmptyHrefOrTurboOrVcardIdOrPermalink;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.turboPageNotFound;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

public class BannerWithTurboLandingConstraints {

    /**
     * Проверка, что турболендинг с нужным id доступен клиенту
     */
    public static Constraint<Long, Defect> turboLandingExists(Collection<Long> existing) {
        return fromPredicate(
                existing::contains,
                turboPageNotFound()
        );
    }

    /**
     * Проверка что шаблон турболендинга разрешен для этого баннера
     */
    static Constraint<Long, Defect> turboLandingPresetValid(TurboLanding turboLanding,
                                                            Collection<TurbolandingsPreset> allowedPresets) {
        return fromPredicate(
                id -> turboLanding.getPreset() == null || allowedPresets.contains(turboLanding.getPreset()),
                inconsistentStateBannerTypeAndTurbolandingType()
        );
    }

    static <B extends BannerWithHrefAndTurboLandingAndVcardAndOrganization> Constraint<B, Defect>
    hrefOrTurboLandingOrVcardOrOrganizationIsSet(boolean clientHasDesktopTurbolandingFeature) {
        return fromPredicate(b -> b.getHref() != null ||
                        b.getVcardId() != null ||
                        b.getPermalinkId() != null ||
                        (clientHasDesktopTurbolandingFeature && b.getTurboLandingId() != null),
                requiredButEmptyHrefOrTurboOrVcardIdOrPermalink());
    }
}
