package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.List;
import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersModerationContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.core.entity.banner.type.turbolanding.moderation.BannerWithTurboLandingModerationProcessor;
import ru.yandex.direct.core.entity.banner.type.turbolanding.moderation.DefaultBannerWithTurboLandingModerationProcessor;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.creative.model.CreativeType;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration.TURBO_LANDING_ID;

@Component
public class BannerWithTurboLandingModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithTurboLandingModeration> {

    private BannerWithChildrenModerationProvider<BannerWithTurboLandingModeration> provider;

    @Autowired
    public BannerWithTurboLandingModerationUpdateOperationTypeSupport(
            List<BannerWithTurboLandingModerationProcessor<?>> processors) {
        provider =
                new BannerWithChildrenModerationProvider<>(DefaultBannerWithTurboLandingModerationProcessor.class,
                        processors);
    }

    @Override
    public Class<BannerWithTurboLandingModeration> getTypeClass() {
        return BannerWithTurboLandingModeration.class;
    }

    @Override
    public boolean needModeration(BannersModerationContainer container,
                                  AppliedChanges<BannerWithTurboLandingModeration> appliedChanges) {
        var banner = appliedChanges.getModel();
        var campaign = container.getCampaign(banner);
        // Для cpm_yndx_frontpage статус турболендинга связан со статусом баннера.
        // Также турболинки отправляются в составе canvas-баннеров, поэтому нужно,
        // чтоб баннер переотправлялся на модерацию при изменении турболинка.
        return appliedChanges.changed(TURBO_LANDING_ID) &&
                (isCpmFrontpage(campaign) || isCanvasBanner(container.getCreativeByIdMap(), banner));
    }

    private boolean isCpmFrontpage(CommonCampaign campaign) {
        return campaign.getType() == CampaignType.CPM_YNDX_FRONTPAGE;
    }

    private boolean isCanvasBanner(Map<Long, Creative> idToCreativeMap, BannerWithTurboLandingModeration banner) {
        if (banner instanceof BannerWithCreative) {
            BannerWithCreative bannerWithCreative = (BannerWithCreative) banner;
            Long creativeId = bannerWithCreative.getCreativeId();
            Creative creative = idToCreativeMap.get(creativeId);
            if (creative != null && creative.getType() == CreativeType.CANVAS) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void beforeExecutionInTransaction(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer updateContainer,
            List<AppliedChanges<BannerWithTurboLandingModeration>> appliedChanges) {
        provider.process(dsl, additionalActionsContainer, updateContainer, appliedChanges);
    }
}
