package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerTurboLandingStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLanding;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityUpsertRepositoryTypeSupport;
import ru.yandex.direct.core.entity.banner.repository.type.ModifiedPaths;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerTurbolandingsRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.grut.objects.proto.client.Schema;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.core.entity.banner.type.turbolanding.BannerWithTurbolandingConstants.NEW_BANNER_TURBO_LANDINGS_PROPERTIES;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboLandingRepositoryTypeSupport
        extends AbstractFlatRelatedEntityUpsertRepositoryTypeSupport
        <BannerWithTurboLanding, BannerTurbolandingsRecord> {

    private static final Set<ModelProperty<? super BannerWithTurboLanding, ?>> GRUT_PROPERTIES =
            Set.of(BannerWithTurboLanding.TURBO_LANDING_ID);

    @Autowired
    public BannerWithTurboLandingRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNER_TURBOLANDINGS.BID, createMapper());
    }

    @Override
    protected boolean isAddEntity(BannerWithTurboLanding model) {
        return model.getTurboLandingId() != null;
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<BannerWithTurboLanding> appliedChange) {
        return appliedChange.deleted(BannerWithTurboLanding.TURBO_LANDING_ID);
    }

    @Override
    protected boolean isUpsertEntity(AppliedChanges<BannerWithTurboLanding> ac) {
        return !isDeleteEntity(ac) && NEW_BANNER_TURBO_LANDINGS_PROPERTIES.stream().anyMatch(ac::changed);
    }

    @Override
    protected void upsertEntity(
            DSLContext context,
            Collection<BannerWithTurboLanding> banners) {
        var insertHelper = new InsertHelper<>(context, BANNER_TURBOLANDINGS);
        insertHelper.addAll(getJooqMapper(), banners);
        insertHelper.onDuplicateKeyUpdate()
                .set(BANNER_TURBOLANDINGS.TL_ID, MySQLDSL.values(BANNER_TURBOLANDINGS.TL_ID))
                .set(BANNER_TURBOLANDINGS.STATUS_MODERATE, MySQLDSL.values(BANNER_TURBOLANDINGS.STATUS_MODERATE));
        insertHelper.executeIfRecordsAdded();
    }

    @Override
    public Class<BannerWithTurboLanding> getTypeClass() {
        return BannerWithTurboLanding.class;
    }

    private static JooqMapper<BannerWithTurboLanding> createMapper() {
        return JooqMapperBuilder.<BannerWithTurboLanding>builder()
                .map(property(BannerWithTurboLanding.TURBO_LANDING_ID, BANNER_TURBOLANDINGS.TL_ID))
                .map(convertibleProperty(BannerWithTurboLanding.TURBO_LANDING_STATUS_MODERATE,
                        BANNER_TURBOLANDINGS.STATUS_MODERATE,
                        BannerTurboLandingStatusModerate::fromSource,
                        BannerTurboLandingStatusModerate::toSource))
                .writeField(BANNER_TURBOLANDINGS.BID, fromProperty(BannerWithTurboLanding.ID))
                .writeField(BANNER_TURBOLANDINGS.CID, fromProperty(BannerWithTurboLanding.CAMPAIGN_ID))
                .build();
    }

    @Override
    public Set<ModelProperty<? super BannerWithTurboLanding, ?>> getGrutSupportedProperties() {
        return GRUT_PROPERTIES;
    }

    @Override
    public Map<Long, ModifiedPaths> applyToGrutObjects(
            @NotNull Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
            @NotNull Collection<AppliedChanges<BannerWithTurboLanding>> appliedChangesList,
            @NotNull BannersOperationContainer operationContainer) {
        Map<Long, ModifiedPaths> modifiedPathsMap = new HashMap<>();
        for (var appliedChanges : appliedChangesList) {
            if (appliedChanges.getPropertiesForUpdate().contains(BannerWithTurboLanding.TURBO_LANDING_ID)) {
                Long id = appliedChanges.getModel().getId();
                var newValue = appliedChanges.getNewValue(BannerWithTurboLanding.TURBO_LANDING_ID);
                ModifiedPaths modifiedPaths;
                if (newValue != null) {
                    Schema.TBannerV2.Builder bannerBuilder = bannerBuilders.get(id);
                    bannerBuilder.getSpecBuilder().setTurbolandingId(newValue);
                    bannerBuilder.getSpecBuilder().setTurbolandingHref(
                            operationContainer.getTurboLandings().get(newValue).getUrl()
                    );
                    modifiedPaths = new ModifiedPaths(Set.of(
                            "/spec/turbolanding_id", "/spec/turbolanding_href"), emptySet());
                } else {
                    modifiedPaths = new ModifiedPaths(emptySet(),
                            Set.of("/spec/turbolanding_id", "/spec/turbolanding_href"));
                }
                modifiedPathsMap.put(id, modifiedPaths);
            }
        }
        return modifiedPathsMap;
    }
}
