package ru.yandex.direct.core.entity.banner.type.turbolanding;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLanding;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration.TURBO_LANDING_ID;

@Component
public class BannerWithTurboLandingUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithTurboLanding> {

    @Override
    public Class<BannerWithTurboLanding> getTypeClass() {
        return BannerWithTurboLanding.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithTurboLanding> appliedChanges) {
        return appliedChanges.changed(TURBO_LANDING_ID);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithTurboLanding> appliedChanges) {
        return appliedChanges.changed(TURBO_LANDING_ID);
    }
}
