package ru.yandex.direct.core.entity.banner.type.turbolanding;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLanding;
import ru.yandex.direct.dbschema.ppc.enums.TurbolandingsPreset;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.dbschema.ppc.enums.TurbolandingsPreset.cpm_geoproduct_preset;
import static ru.yandex.direct.dbschema.ppc.enums.TurbolandingsPreset.cpm_geoproduct_pro_preset;

public class BannerWithTurbolandingConstants {

    public static final Set<ModelProperty<? super BannerWithTurboLanding, ?>> NEW_BANNER_TURBO_LANDINGS_PROPERTIES =
            Set.of(BannerWithTurboLanding.TURBO_LANDING_ID,
                    BannerWithTurboLanding.TURBO_LANDING_STATUS_MODERATE);

    /**
     * Шаблоны турбо, доступные по умолчанию
     */
    public static final Set<TurbolandingsPreset> DEFAULT_ALLOWED_PRESETS = EnumSet.allOf(TurbolandingsPreset.class);

    /**
     * Максимальная длина дополнительных параметров URL турболендингов
     */
    public static final int MAX_LENGTH_TURBOLANDING_PARAMS = 1024;

    private static final Set<TurbolandingsPreset> CPM_GEOPRODUCT_PRESET = ImmutableSet.of(cpm_geoproduct_preset,
            cpm_geoproduct_pro_preset);

    public static final Map<AdGroupType, Set<TurbolandingsPreset>> ALLOWED_TURBO_PRESETS_BY_GROUP_TYPE =
            ImmutableMap.of(
                    AdGroupType.CPM_GEOPRODUCT, CPM_GEOPRODUCT_PRESET,
                    AdGroupType.CPM_BANNER, DEFAULT_ALLOWED_PRESETS
            );
}
