package ru.yandex.direct.core.entity.banner.type.turbolanding.moderation;

import java.util.List;

import org.jooq.DSLContext;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerTurboLandingStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.AbstractBannerWithChildrenModerationProcessor;
import ru.yandex.direct.core.entity.moderation.service.ModerationService;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration.STATUS_MODERATE;
import static ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration.TURBO_LANDING_ID;
import static ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration.TURBO_LANDING_STATUS_MODERATE;
import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerBecameDraft;
import static ru.yandex.direct.core.entity.banner.service.BannerUtils.getCampaignIdToBannerIds;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public abstract class AbstractBannerWithTurboLandingModerationProcessor
        extends AbstractBannerWithChildrenModerationProcessor<BannerWithTurboLandingModeration,
                DefaultBannerWithTurboLandingModerationContainer>
        implements BannerWithTurboLandingModerationProcessor<BannerWithTurboLandingModeration> {

    private final ModerationService moderationService;

    AbstractBannerWithTurboLandingModerationProcessor(ModerationService moderationService) {
        this.moderationService = moderationService;
    }

    @Override
    protected DefaultBannerWithTurboLandingModerationContainer prepareContainer(
            BannersUpdateOperationContainer container,
            List<AppliedChanges<BannerWithTurboLandingModeration>> appliedChanges) {
        return new DefaultBannerWithTurboLandingModerationContainer();
    }

    @Override
    protected void process(
            BannerAdditionalActionsContainer additionalActionsContainer, BannersUpdateOperationContainer container,
            DefaultBannerWithTurboLandingModerationContainer moderationContainer,
            AppliedChanges<BannerWithTurboLandingModeration> changes) {
        if (!changes.hasActuallyChangedProps() && container.getModerationMode().isDefault()) {
            return;
        }

        boolean bannerTurbolandingChanged = changes.changed(TURBO_LANDING_ID);
        boolean isTurboLandingNotNull = changes.getModel().getTurboLandingId() != null;

        if (bannerTurbolandingChanged) {
            moderationContainer.addToModeration(changes.getModel());
        }


        if (isTurboLandingNotNull && bannerBecameDraft(changes)) {
            changes.modify(TURBO_LANDING_STATUS_MODERATE, BannerTurboLandingStatusModerate.NEW);
            return;
        }

        if (isTurboLandingNotNull
                && (bannerTurbolandingChanged || changes.getNewValue(STATUS_MODERATE) == BannerStatusModerate.READY)) {
            changes.modify(TURBO_LANDING_STATUS_MODERATE, BannerTurboLandingStatusModerate.READY);
        }

        processAdditional(container, moderationContainer, changes);
    }

    protected void processAdditional(
            BannersUpdateOperationContainer container,
            DefaultBannerWithTurboLandingModerationContainer moderationContainer,
            AppliedChanges<BannerWithTurboLandingModeration> changes) {
    }

    @Override
    protected void postProcess(DSLContext dsl,
                               BannersUpdateOperationContainer container,
                               DefaultBannerWithTurboLandingModerationContainer moderationContainer) {
        var banners = moderationContainer.getBannersWithTurboLandingToModeration();
        var allBannerIds = mapList(banners, BannerWithTurboLandingModeration::getId);
        var campaignIdToBannerIdsForDelete = getCampaignIdToBannerIds(banners, b -> b.getTurboLandingId() == null);
        moderationService.clearBannerTurboLandingsModeration(dsl,
                allBannerIds,
                campaignIdToBannerIdsForDelete);
    }
}
