package ru.yandex.direct.core.entity.banner.type.turbolanding.moderation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerTurboLandingStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.moderation.service.ModerationService;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration.TURBO_LANDING_STATUS_MODERATE;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeUtils.isOverlayBanner;

@Component
public class CpmBannerWithTurboLandingModerationProcessor
        extends AbstractBannerWithTurboLandingModerationProcessor {

    @Autowired
    public CpmBannerWithTurboLandingModerationProcessor(ModerationService moderationService) {
        super(moderationService);
    }

    @Override
    public Class<CpmBanner> getProcessedClass() {
        return CpmBanner.class;
    }

    @Override
    protected void processAdditional(BannersUpdateOperationContainer container,
                                     DefaultBannerWithTurboLandingModerationContainer moderationContainer,
                                     AppliedChanges<BannerWithTurboLandingModeration> changes) {
        var banner = changes.getModel();
        var adGroup = container.getAdGroup(banner);

        boolean isTurboLandingNotNull = changes.getModel().getTurboLandingId() != null;

        // TODO(временно): баннеры геопродукта не отправляем на модерацию
        if (isTurboLandingNotNull &&
                adGroup.getType() == AdGroupType.CPM_GEOPRODUCT && container.isCpmGeoProductAutoModeration()) {
            changes.modify(TURBO_LANDING_STATUS_MODERATE, BannerTurboLandingStatusModerate.YES);
        }

        // Турбо-страницы оверлейного баннера не отправляем на модерацию
        if (isTurboLandingNotNull &&
                isOverlayBanner(changes.getModel(), container.getBannerToCreativeMap())) {
            changes.modify(TURBO_LANDING_STATUS_MODERATE, BannerTurboLandingStatusModerate.YES);
        }
    }
}
