package ru.yandex.direct.core.entity.banner.type.turbolandingparams;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingParams;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractRelatedSingleFieldRepositoryTypeSupport;
import ru.yandex.direct.core.entity.banner.repository.type.ModifiedPaths;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerTurbolandingParamsRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.grut.objects.proto.client.Schema;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDING_PARAMS;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboLandingParamsRepositoryTypeSupport
        extends AbstractRelatedSingleFieldRepositoryTypeSupport<BannerWithTurboLandingParams,
        String, BannerTurbolandingParamsRecord, String> {

    private static final Set<ModelProperty<? super BannerWithTurboLandingParams, ?>> GRUT_PROPERTIES =
            Set.of(BannerWithTurboLandingParams.TURBO_LANDING_HREF_PARAMS);

    @Autowired
    public BannerWithTurboLandingParamsRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider,
                BannerWithTurboLandingParams.TURBO_LANDING_HREF_PARAMS,
                BANNER_TURBOLANDING_PARAMS.BID,
                BANNER_TURBOLANDING_PARAMS.HREF_PARAMS,
                Function.identity(),
                Function.identity());
    }

    @Override
    public Class<BannerWithTurboLandingParams> getTypeClass() {
        return BannerWithTurboLandingParams.class;
    }

    @Override
    public Set<ModelProperty<? super BannerWithTurboLandingParams, ?>> getGrutSupportedProperties() {
        return GRUT_PROPERTIES;
    }

    @Override
    public Map<Long, ModifiedPaths> applyToGrutObjects(
            @NotNull Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
            @NotNull Collection<AppliedChanges<BannerWithTurboLandingParams>> appliedChangesList,
            @NotNull BannersOperationContainer operationContainer) {
        Map<Long, ModifiedPaths> modifiedPathsMap = new HashMap<>();
        for (var appliedChanges : appliedChangesList) {
            if (appliedChanges.getPropertiesForUpdate().contains(BannerWithTurboLandingParams.TURBO_LANDING_HREF_PARAMS)) {
                Long id = appliedChanges.getModel().getId();
                var newValue = appliedChanges.getNewValue(BannerWithTurboLandingParams.TURBO_LANDING_HREF_PARAMS);
                ModifiedPaths modifiedPaths;
                if (newValue != null) {
                    Schema.TBannerV2.Builder bannerBuilder = bannerBuilders.get(id);
                    bannerBuilder.getSpecBuilder().setTurbolandingHrefParams(newValue);
                    modifiedPaths = new ModifiedPaths(Set.of("/spec/turbolanding_href_params"), emptySet());
                } else {
                    modifiedPaths = new ModifiedPaths(emptySet(), Set.of("/spec/turbolanding_href_params"));
                }
                modifiedPathsMap.put(id, modifiedPaths);
            }
        }
        return modifiedPathsMap;
    }
}
