package ru.yandex.direct.core.entity.banner.type.turbolandingparams;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingParams;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboLandingParamsUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithTurboLandingParams> {

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithTurboLandingParams> appliedChanges) {
        return appliedChanges.changed(BannerWithTurboLandingParams.TURBO_LANDING_HREF_PARAMS);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithTurboLandingParams> appliedChanges) {
        return appliedChanges.changed(BannerWithTurboLandingParams.TURBO_LANDING_HREF_PARAMS);
    }

    @Override
    public Class<BannerWithTurboLandingParams> getTypeClass() {
        return BannerWithTurboLandingParams.class;
    }
}
