package ru.yandex.direct.core.entity.banner.type.turbolandingparams;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingParams;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboLandingParamsUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithTurboLandingParams> {

    private final BannerWithTurboLandingParamsValidatorProvider validatorProvider;

    @Autowired
    public BannerWithTurboLandingParamsUpdateValidationTypeSupport(
            BannerWithTurboLandingParamsValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public ValidationResult<List<BannerWithTurboLandingParams>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithTurboLandingParams>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.validator())
                .getResult();
    }

    @Override
    public Class<BannerWithTurboLandingParams> getTypeClass() {
        return BannerWithTurboLandingParams.class;
    }
}
